///////////////////////////////////////////////////////////////////////////////////////
//
// MonoScan
//
// 27/04/07		Hounddog	Initial implementation
//

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text;

namespace MonoScan
{
	/// <summary>
	/// Summary description for OptionsForm.
	/// </summary>
	public class OptionsForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.ComboBox portComboBox;
		private System.Windows.Forms.TextBox baudRatesTextBox;
		private System.Windows.Forms.ComboBox messageLevelComboBox;
		private System.Windows.Forms.Button cancelButton;
		private System.Windows.Forms.Button okButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public OptionsForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		public int CommPort
		{
			get { return portComboBox.SelectedIndex + 1; }

			set
			{
				if (value < 1 || value > portComboBox.Items.Count)
					throw new Exception("Invalid comm port number: " + value.ToString());

				portComboBox.SelectedIndex = value - 1;
			}
		}

		public uint[] BaudRates
		{
			get 
			{
				string[] strings = baudRatesTextBox.Text.Split(new char[] {' '});

				ArrayList arrayList = new ArrayList();

				for (int i = 0; i < strings.Length; ++ i)
				{
					if (strings[i] != "")
						arrayList.Add(uint.Parse(strings[i]));
				}

				return (uint[]) arrayList.ToArray(typeof(uint));
			}

			set
			{
				StringBuilder stringBuilder = new StringBuilder();

				for (int i = 0; i < value.Length; ++ i)
				{
					if (i > 0)
						stringBuilder.Append(' ');

					stringBuilder.Append(value[i]);
				}

				baudRatesTextBox.Text = stringBuilder.ToString();
			}
		}

		public MonoComm.MessageLevel MessageLevel
		{
			get { return (MonoComm.MessageLevel) messageLevelComboBox.SelectedIndex; }

			set	{ messageLevelComboBox.SelectedIndex = (int) value; }
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.portComboBox = new System.Windows.Forms.ComboBox();
			this.baudRatesTextBox = new System.Windows.Forms.TextBox();
			this.messageLevelComboBox = new System.Windows.Forms.ComboBox();
			this.cancelButton = new System.Windows.Forms.Button();
			this.okButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(56, 12);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(112, 23);
			this.label1.TabIndex = 0;
			this.label1.Text = "Communication Port";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 44);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(160, 23);
			this.label2.TabIndex = 1;
			this.label2.Text = "Baud Rates (space separated)";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(76, 76);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(92, 23);
			this.label3.TabIndex = 2;
			this.label3.Text = "Messages Level";
			// 
			// portComboBox
			// 
			this.portComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.portComboBox.Items.AddRange(new object[] {
															  "Com 1",
															  "Com 2",
															  "Com 3",
															  "Com 4",
															  "Com 5",
															  "Com 6",
															  "Com 7",
															  "Com 8"});
			this.portComboBox.Location = new System.Drawing.Point(176, 8);
			this.portComboBox.Name = "portComboBox";
			this.portComboBox.Size = new System.Drawing.Size(96, 21);
			this.portComboBox.TabIndex = 3;
			// 
			// baudRatesTextBox
			// 
			this.baudRatesTextBox.Location = new System.Drawing.Point(176, 40);
			this.baudRatesTextBox.Name = "baudRatesTextBox";
			this.baudRatesTextBox.Size = new System.Drawing.Size(96, 20);
			this.baudRatesTextBox.TabIndex = 4;
			this.baudRatesTextBox.Text = "";
			// 
			// messageLevelComboBox
			// 
			this.messageLevelComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.messageLevelComboBox.Items.AddRange(new object[] {
																	  "None",
																	  "Errors",
																	  "Log 0",
																	  "Log 1",
																	  "Log 2"});
			this.messageLevelComboBox.Location = new System.Drawing.Point(176, 72);
			this.messageLevelComboBox.Name = "messageLevelComboBox";
			this.messageLevelComboBox.Size = new System.Drawing.Size(96, 21);
			this.messageLevelComboBox.TabIndex = 5;
			// 
			// cancelButton
			// 
			this.cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.cancelButton.Location = new System.Drawing.Point(197, 114);
			this.cancelButton.Name = "cancelButton";
			this.cancelButton.TabIndex = 6;
			this.cancelButton.Text = "&Cancel";
			// 
			// okButton
			// 
			this.okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.okButton.Location = new System.Drawing.Point(113, 114);
			this.okButton.Name = "okButton";
			this.okButton.TabIndex = 7;
			this.okButton.Text = "&OK";
			// 
			// OptionsForm
			// 
			this.AcceptButton = this.okButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.cancelButton;
			this.ClientSize = new System.Drawing.Size(280, 145);
			this.Controls.Add(this.okButton);
			this.Controls.Add(this.cancelButton);
			this.Controls.Add(this.messageLevelComboBox);
			this.Controls.Add(this.baudRatesTextBox);
			this.Controls.Add(this.portComboBox);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "OptionsForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Settings";
			this.ResumeLayout(false);

		}
		#endregion
	}
}
